<?php use App\Enums\Media\MediaCollection;use Illuminate\Support\Str; ?>

<?php $__env->startSection('page-name', $course->slug); ?>

<?php $__env->startSection('content'); ?>
    <!-- Header Section -->
    <section class="header-bg">
        <div class="container-fluid p-100">
            <div class="header-section">
                <div class="overlay"></div>
                <div class="header-content">
                    <p class="small-title" data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                        <?php echo e(__("lang.Home")); ?>

                        <img
                            src="<?php echo e(asset('website/assets/images/smallchervon left.svg')); ?>"
                            alt="Arrow"
                            class="breadcrumb-arrow"
                            style="<?php echo e(app()->getLocale() === 'ar' ? 'transform: rotate(180deg)' : ''); ?>">

                        <?php echo e(__("lang.Courses")); ?>

                    </p>
                    <h1 class="header-title-innercourse" data-aos="fade-up" data-aos-duration="1000"
                        data-aos-offset="10">
                        <?php echo e(getColumn($course, "name")); ?>

                    </h1>
                </div>
            </div>
        </div>
    </section>

    <!-- Childhood Section -->
    <section class="childhood-section">
        <div class="container-fluid p-100 mt-5">
            <div class="row align-items-center">
                <!-- Left Side with Image and Badge -->
                <div class="col-md-6 position-relative">
                    <img
                        src="<?php echo e($course->getFirstMediaUrl(app()->getLocale() == 'ar' ? MediaCollection::INNER_COURSE_IMAGE_ARABIC->value : MediaCollection::INNER_COURSE_IMAGE_ENGLISH->value)); ?>"
                        alt="<?php echo e(__("lang.Course Image")); ?>" class="book-innerpage-img"
                        data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                    <span class="badge position-absolute badge-custom"><?php echo e(getColumn($course->category, "name")); ?></span>
                </div>

                <!-- Right Side with Course Details -->
                <div class="col-md-6">
                    <h2 class="bookinner-text" data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                        <?php echo e(__("lang.Course")); ?>

                    </h2>
                    <h2 class="bookinner-title" data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                        <?php echo e(getColumn($course, "name")); ?>

                    </h2>

                    <div class="buy-now-prices bookinner-title d-flex align-items-center " data-aos="fade-up"
                         data-aos-duration="1000" data-aos-offset="10">
                        <?php if( $course->sale_price): ?>
                            <h5 class="original-price mx-2"><span>$</span><?php echo e($course->price); ?></h5>
                            <h5 class="discounted-price"><span>$</span><?php echo e($course->sale_price); ?></h5>
                        <?php else: ?>
                            <h5 class="discounted-price"><span>$</span><?php echo e($course->price); ?></h5>
                        <?php endif; ?>
                    </div>
                    <!-- ShareThis BEGIN -->
                    <div class="sharethis-inline-share-buttons"></div>
                    <!-- ShareThis END -->
                    <p class="bookinner-description" data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                        <?php echo getColumn($course, "short_description"); ?>

                    </p>

                    <?php if(auth()->guard()->check()): ?>
                        <form action="<?php echo e(route('checkout')); ?>" method="POST">
                            <?php echo csrf_field(); ?>


                            <input hidden="" name="product_slug" value="<?php echo e($course->slug); ?>">
                            <input hidden="" name="product_model" value="<?php echo e(get_class($course)); ?>">

                            <button type="submit" class="buy-now-innerbtn" data-aos="fade-up" data-aos-duration="1000"
                                    data-aos-offset="10">
                                <?php echo e(__('lang.Buy Now')); ?>

                            </button>
                        </form>
                    <?php else: ?>
                        <a href="#" id="buy-now-btn" class="buy-now-innerbtn" data-aos="fade-up"
                           data-aos-duration="1000"
                           data-aos-offset="10"><?php echo e(__("lang.Buy Now")); ?></a>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </section>

    <!-- Popup HTML -->
    <div id="popup" class="popup-container d-none">
        <div class="popup-content">
            <div class="popup-left">
                <img src="<?php echo e(asset('website/assets/images/truepopup.svg')); ?>" alt="Icon" class="popup-icon">
                <div class="popup-text-buy">
                    <h3><?php echo e(__("lang.Login Signup")); ?></h3>
                    <p><?php echo e(__("lang.Login Signup Description")); ?></p>
                </div>
            </div>
            <div class="buttons-login-popup">
                <a class="login-signup-button-popup"
                   href="<?php echo e(route('login.show')); ?>"><?php echo e(__("lang.Login Signup Button")); ?></a>
                <button class="close-buybutton-popup" onclick="hidePopup()"><?php echo e(__("lang.Close")); ?></button>
            </div>
        </div>
    </div>
    <!-- Description Inner Course Section -->

    <section class="desc-inner-course">
        <div class="container-fluid p-100">
            <div class="row">
                <!-- Left Content Section -->
                <div class="col-md-8">
                    <div class="section-description mb-3">
                        <div class="btn-desc-inner" data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                            <?php echo e(__("lang.Description")); ?>

                        </div>
                        <hr class="custom-desc-hr" data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                    </div>

                    <h3 class="desc-inner-title mt-5" data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                        <?php echo e(__("lang.Description Title")); ?>

                    </h3>
                    <p class="desc-inner-paragraph" data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                        <?php echo getColumn($course, 'long_description'); ?>

                    </p>

                    <h4 class="desc-inner-title" data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                        <?php echo e(getColumn($course, "first_highlight")); ?>

                    </h4>
                    <?php echo getColumn($course, "objectives"); ?>


                    <h4 class="desc-inner-title" data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                        <?php echo e(getColumn($course, "second_highlight")); ?>

                    </h4>
                    <?php echo getColumn($course, "course_highlights"); ?>


                    <h4 class="desc-inner-title mt-4" data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                        <?php echo e(__("lang.Instructor Information")); ?>

                    </h4>
                    <div class="instructor-content-section">
                        <div>
                            <img src="<?php echo e($course->getFirstMediaUrl(MediaCollection::COURSE_INSTRUCTOR_IMAGE->value)); ?>"
                                 alt="<?php echo e(__("lang.Instructor Image")); ?>" class="custom-img-innercourse"
                                 data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                        </div>
                        <div class="instructor-content">
                            <h4 data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                                <?php echo e(getColumn($course, "instructor_name")); ?>

                            </h4>
                            <h5 data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                                <?php echo e(getColumn($course, "instructor_position")); ?>

                            </h5>
                            <p data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                                <?php echo getColumn($course, "instructor_short_description"); ?>

                            </p>
                        </div>

                    </div>
                </div>

                <!-- Right Card Section -->
                <div class="col-md-4">
                    <div class="card-cerfificate">
                        <div class="earn">
                            <h6 data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                                <?php echo e(__("lang.Earn")); ?>

                            </h6>
                            <p data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                                <?php echo e(getColumn($course, 'earn')); ?>

                            </p>
                        </div>
                        <div class="time">
                            <h6 data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                                <?php echo e(__("lang.Time")); ?>

                            </h6>
                            <p data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                                <?php echo e($course->time); ?> <?php echo e(__("lang.Hours")); ?>

                            </p>
                        </div>
                        <div class="Prerequisites">
                            <h6 data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                                <?php echo e(__("lang.Prerequisites")); ?>

                            </h6>
                            <p data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                                <?php echo e(getColumn($course, 'prerequisites')); ?>

                            </p>
                        </div>
                        <div class="Prerequisites mb-0">
                            <h6 data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                                <?php echo e(__("lang.Age Group")); ?>

                            </h6>
                            <p data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                                <?php echo e($course->age_from); ?> - <?php echo e($course->age_to); ?> <?php echo e(__("lang.Years Old")); ?>

                            </p>
                        </div>
                    </div>
                    <div class="section-description mb-3 mt-5">
                        <div class="btn-desc-inner" data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                            <?php echo e(__('lang.course_info')); ?>

                        </div>
                        <hr class="custom-desc-hr" data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                    </div>

                    <div class="course-curriculum mt-3">
                        <h2><?php echo e(__('lang.course_curriculum')); ?></h2>
                        <div class="curriculum-section">
                            <div class="curriculum-header d-flex justify-content-between align-items-center"
                                 data-bs-toggle="collapse" data-bs-target="#newVideoList" aria-expanded="false"
                                 aria-controls="newVideoList">
                                <div class="d-flex align-items-center">
                                    <i class="bi bi-chevron-down chevron-Curriculum"></i>
                                    <span class="curriculum-title"><?php echo e(getColumn($course, 'name')); ?></span>
                                </div>
                            </div>

                            <div id="newVideoList" class="collapse">
                                <?php $__currentLoopData = $course->videos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $video): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="row new-video-item" style="padding: 10px" data-day="1">
                                        <?php if(!$HasPurchasedCourse): ?>
                                        <div class="col-1">
                                            <i class="bi bi-lock-fill lock-icon-Curriculum" id="lock1"></i>
                                        </div>
                                        <?php endif; ?>
                                        <div class="col-7">
                                            <span class="day-title"><?php echo e(getColumn($video, 'title')); ?></span>
                                        </div>
                                        <?php if($HasPurchasedCourse): ?>
                                            <div class="col-2">
                                                <a href="<?php echo e(route('courses.videos.show', ['slug' => $course->slug, 'video_id'=> $video->id])); ?>"
                                                   target="_blank">
                                                    <i id="play-btn-1"
                                                       class="bi bi-play-circle play-icon-Curriculum"></i>
                                                </a>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
        </div>
    </section>

    <!-- Interested Courses Section -->
    <section class="interested-books-section">
        <div class="container-fluid p-100">
            <h5 class="interested-books-title" data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                <?php echo e(__("lang.You Might Be Interested In")); ?>

            </h5>
            <div class="row">
                <!-- Course Card -->
                <?php $__currentLoopData = $interested_courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $interested_course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-md-3 mb-4">
                        <div class="buy-now-card">
                            <img
                                src="<?php echo e($interested_course->getFirstMediaUrl(app()->getLocale() == 'ar' ? MediaCollection::LIST_COURSE_IMAGE_ARABIC->value : MediaCollection::LIST_COURSE_IMAGE_ENGLISH->value)); ?>"
                                class="buy-img-card" alt="<?php echo e(__("lang.Course Image")); ?>"
                                data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                            <div class="buy-now-card-body">
                                <h5 class="buy-now-title" data-aos="fade-up" data-aos-duration="1000"
                                    data-aos-offset="10">
                                    <?php echo e(getColumn($interested_course, 'name')); ?>

                                </h5>
                                <p class="buy-now-desc" data-aos="fade-up" data-aos-duration="1000"
                                   data-aos-offset="10">
                                    <?php echo getColumn($interested_course, 'short_description'); ?>

                                </p>
                                <div class="buy-now-prices d-flex align-items-center" data-aos="fade-up"
                                     data-aos-duration="1000" data-aos-offset="10">
                                    <?php if( $interested_course->sale_price): ?>
                                        <h5 class="original-price"><span>$</span><?php echo e($interested_course->price); ?></h5>
                                        <h5 class="discounted-price"><span>$</span><?php echo e($interested_course->sale_price); ?>

                                        </h5>
                                    <?php else: ?>
                                        <h5 class="discounted-price"><span>$</span><?php echo e($interested_course->price); ?></h5>
                                    <?php endif; ?>
                                </div>
                                <a href="#" class="buy-now-btn" data-aos="fade-up" data-aos-duration="1000"
                                   data-aos-offset="10"><?php echo e(__("lang.Buy Now")); ?></a>
                                <a href="<?php echo e(route('courses.show', ['slug' => $interested_course->slug])); ?>"
                                   class="buynow-see-details" data-aos="fade-up" data-aos-duration="1000"
                                   data-aos-offset="10"><?php echo e(__("lang.See Details")); ?></a>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </section>

<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
    <script type='text/javascript'
            src='https://platform-api.sharethis.com/js/sharethis.js#property=59ecdf1a95f7b200121c2a4d&product=inline-share-buttons'
            async='async'></script>

    <script>
        // Sample data for locked/unlocked state of videos
        const videoStates = {
            1: false,
            2: true,
            3: false,
            4: true
        };

        function updateLockIcons() {
            for (let day in videoStates) {
                const lockIcon = document.getElementById(`lock${day}`);
                if (videoStates[day]) {
                    lockIcon.classList.remove('bi-lock-fill');
                    lockIcon.classList.add('bi-unlock-fill');
                    lockIcon.style.color = 'black'; // Unlocked color
                } else {
                    lockIcon.classList.remove('bi-unlock-fill');
                    lockIcon.classList.add('bi-lock-fill');
                    lockIcon.style.color = 'gray'; // Locked color
                }
            }
        }

        function updatePlayButtons() {
            for (let day in videoStates) {
                const playButton = document.getElementById(`play-btn-${day}`);
                if (!videoStates[day]) {
                    playButton.classList.add('disabled');
                    playButton.style.pointerEvents = 'none';
                    playButton.style.color = 'gray';
                } else {
                    playButton.classList.remove('disabled');
                    playButton.style.pointerEvents = 'auto';
                    playButton.style.color = 'black';
                }
            }
        }

        updateLockIcons();
        updatePlayButtons();

    </script>


<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/intcoredev/public_html/kydzoo.intcore.dev/resources/views/website/courses-show.blade.php ENDPATH**/ ?>