<?php

use App\Http\Controllers\Website\AboutUsController;
use App\Http\Controllers\Website\AuthController;
use App\Http\Controllers\Website\BlogController;
use App\Http\Controllers\Website\BookController;
use App\Http\Controllers\Website\CheckoutController;
use App\Http\Controllers\Website\ConsultationController;
use App\Http\Controllers\Website\ContactController;
use App\Http\Controllers\Website\CourseController;
use App\Http\Controllers\Website\EventController;
use App\Http\Controllers\Website\HomeController;
use App\Http\Controllers\Website\PageController;
use App\Http\Controllers\Website\PaymentController;
use App\Http\Controllers\Website\ProfileController;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Route;
use Mcamara\LaravelLocalization\Facades\LaravelLocalization;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/
Route::group(
    [
        'prefix' => LaravelLocalization::setLocale(),
        'middleware' => ['localeSessionRedirect', 'localizationRedirect', 'localeViewPath']
    ], function () {

    Route::get('/', [HomeController::class, 'index'])->name('home');

    Route::get('/books', [BookController::class, 'index'])->name('books.index');
    Route::get('/books/{slug}', [BookController::class, 'show'])->name('books.show');


    Route::get('/courses', [CourseController::class, 'index'])->name('courses.index');
    Route::get('/courses/{slug}', [CourseController::class, 'show'])->name('courses.show');
    Route::get('/courses/{slug}/videos/{video_id}', [CourseController::class, 'showCourseVideos'])->name('courses.videos.show');

    Route::get('/events', [EventController::class, 'index'])->name('events.index');
    Route::get('/events/{slug}', [EventController::class, 'show'])->name('events.show');

    Route::get('/blogs', [BlogController::class, 'index'])->name('blogs.index');
    Route::get('/blogs/{slug}', [BlogController::class, 'show'])->name('blogs.show');

    Route::get('/page/{slug}', [PageController::class, 'show'])->name('pages.show');

    Route::get('login', [App\Http\Controllers\Website\AuthController::class, 'showLoginForm'])->name('login.show');
    Route::post('login', [App\Http\Controllers\Website\AuthController::class, 'login']);
    Route::post('logout', [App\Http\Controllers\Website\AuthController::class, 'logout'])->name('logout');
    Route::get('logout', [App\Http\Controllers\Website\AuthController::class, 'logout'])->name('logout');
    Route::get('/register', [AuthController::class, 'showRegister'])->name('register.show');

    Route::post('/register', [AuthController::class, 'registerSubmit'])->name('register.submit');

    Route::get('forgot-password', [App\Http\Controllers\Website\AuthController::class, 'showLinkRequestForm'])->name('forget.password.form');
    Route::post('forgot-password', [App\Http\Controllers\Website\AuthController::class, 'sendResetLinkEmail'])->name('password.email');

    Route::get('reset-password/{token}', [App\Http\Controllers\Website\AuthController::class, 'showResetForm'])->name('password.reset');
    Route::post('reset-password', [App\Http\Controllers\Website\AuthController::class, 'reset'])->name('password.update');

    Route::get('/contact', [ContactController::class, 'showForm'])->name('contact.form');
    Route::post('/contact', [ContactController::class, 'send'])->name('contact.send');


    Route::get('/about-us', [AboutUsController::class, 'show'])->name('about-us');
    Route::get('/consultation', [ConsultationController::class, 'index'])->name('consultation.index');

    Route::group(['middleware' => 'auth'], function () {
        Route::post('stripe-checkout', [CheckoutController::class, 'checkout'])->name("checkout");

        Route::get('/profile/orders', [ProfileController::class, 'orders'])->name('profile.orders');
        Route::get('/profile/dashboard', [ProfileController::class, 'index'])->name('profile.index');
        Route::get('/profile/edit', [ProfileController::class, 'edit'])->name('profile.edit');
        Route::post('/profile/update', [ProfileController::class, 'update'])->name('profile.update');
        Route::get('/profile/edit/password', [ProfileController::class, 'editPassword'])->name('profile.edit.password');
        Route::post('/profile/update/password', [ProfileController::class, 'updatePassword'])->name('profile.update.password');

    });


});

Route::get('/checkout-cancel', [CheckoutController::class, 'checkoutCancel'])->name('checkout-cancel');
Route::get('/checkout-success', [CheckoutController::class, 'checkoutSuccess'])->name('checkout-success');
Route::get('clear-cache', function () {
    Artisan::call('optimize:clear');
   //Artisan::call('db:seed');

    return "Cache is cleared";
});
