@extends('layouts.master')
@section('content')

    <!-- Header Section -->
    <section class="header-bg">
        <div class="container-fluid p-100">
            <div class="header-contactus">
                <div class="overlay"></div>
                <div class="header-content">
                    <h1 class="header-title-contactus"data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                        {{getColumn($course,'name')}}</h1>
                </div>
            </div>
        </div>
    </section>

    <section class="desc-inner-course">
        <div class="container-fluid p-100">
            <div class="row">
                <!-- Left Video Section -->
                <div class="col-md-8">
                    <div class="section-description mb-3">
                        <div class="btn-desc-inner" data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">  {{getColumn($video,'title')}} </div>
                        <hr class="custom-desc-hr" data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                    </div>
                    <div style="padding:56.25% 0 0 0;position:relative; border-radius: 15px; overflow:hidden;" data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                        <iframe src="https://player.vimeo.com/video/1009918448?badge=0&amp;autopause=0&amp;player_id=0&amp;app_id=58479" frameborder="0" allow="autoplay; fullscreen; picture-in-picture; clipboard-write" style="position:absolute;top:0;left:0;width:100%;height:100%; border-radius: 15px;" title="Arc'teryx Presents: 109 Below"></iframe>
                    </div>
                    <script src="https://player.vimeo.com/api/player.js"></script>
                </div>

                <!-- Right Card Section -->
                <div class="col-md-4 mt-5">
                    <div class="card-cerfificate">
                        <div class="earn">
                            <h6 data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                                {{ __("lang.Earn") }}
                            </h6>
                            <p data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                                {{ $course->earn }}
                            </p>
                        </div>
                        <div class="time">
                            <h6 data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                                {{ __("lang.Time") }}
                            </h6>
                            <p data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                                {{ $course->time }} {{ __("lang.Hours") }}
                            </p>
                        </div>
                        <div class="Prerequisites">
                            <h6 data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                                {{ __("lang.Prerequisites") }}
                            </h6>
                            <p data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                                {{ getColumn($course, 'prerequisites') }}
                            </p>
                        </div>
                        <div class="Prerequisites mb-0">
                            <h6 data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                                {{ __("lang.Age Group") }}
                            </h6>
                            <p data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                                {{ $course->age_from }} - {{ $course->age_to }} {{ __("lang.Years Old") }}
                            </p>
                        </div>
                    </div>
                    <div class="section-description mb-3 mt-5">
                        <div class="btn-desc-inner" data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                            {{ __('lang.course_info') }}
                        </div>
                        <hr class="custom-desc-hr" data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                    </div>

                    <div class="course-curriculum mt-3">
                        <h2>{{ __('lang.course_curriculum') }}</h2>
                        <div class="curriculum-section">
                            <div class="curriculum-header d-flex justify-content-between align-items-center"
                                 data-bs-toggle="collapse" data-bs-target="#newVideoList" aria-expanded="false"
                                 aria-controls="newVideoList">
                                <div class="d-flex align-items-center">
                                    <i class="bi bi-chevron-down chevron-Curriculum"></i>
                                    <span class="curriculum-title">{{ getColumn($course, 'name')}}</span>
                                </div>
                            </div>

                            <div id="newVideoList" class="collapse">
                                @foreach($course->videos as $video)
                                    <div class="row new-video-item" style="padding:10px" data-day="1">
                                        <div class="col-1">
                                            <i class="bi bi-lock-fill lock-icon-Curriculum" id="lock1"></i>
                                        </div>
                                        <div class="col-7">
                                            <span class="day-title">{{getColumn($video, 'title')}}</span>
                                        </div>
                                        @if($HasPurchasedCourse)
                                        <div class="col-2">
                                            <a href="{{ route('courses.videos.show', ['slug' => $course->slug, 'video_id'=> $video->id]) }}" target="_blank">
                                                <i id="play-btn-1" class="bi bi-play-circle play-icon-Curriculum"></i>
                                            </a>
                                        </div>
                                        @endif
                                    </div>
                                @endforeach

                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </section>


@endsection


