<?php

namespace App\Repositories\Interfaces;


use App\DTOs\AbstractDTO;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Pagination\LengthAwarePaginator;

interface BookRepositoryInterface
{

    public function getIsFeatured(AbstractDTO $dto): Collection;
    public function get(AbstractDTO $dto): Collection|LengthAwarePaginator;

    public function getBySlug(string $slug): ?Model;
    public function getInterestedBooks(AbstractDTO $dto, string $categoryId): Collection;

}

