<?php

namespace App\Http\Controllers\Website;

use App\DTOs\Api\AboutUs\GetAboutUsDTO;
use App\DTOs\Api\Page\ShowPageDTO;
use App\Http\Controllers\Controller;
use App\Services\Website\AboutUs\GetAboutUsService;
use App\Services\Website\Page\GetPageService;
use Illuminate\Http\Request;
use Illuminate\View\View;
use App\Models\Page;

class AboutUsController extends Controller
{
    /**
     * AuthController construct
     */
    public function __construct(
        private readonly GetAboutUsService $getAboutUsService,
    ) {
    }

    /**
     * @return View
     * @throws \Exception
     */
    public function show(): View
    {

        $dto = new GetAboutUsDTO([]);
        $pageService = $this->getAboutUsService->setDto($dto)->execute();
   
       $coverDescription = Page::query()->where('slug', \App\Enums\Page\Page::ABOUT_US_COVER_DESCRIPTION->value)->first();

        return view('website.about-us', [
            'about_us_sections' => $pageService,
            'coverDescription' => $coverDescription,
        ]);

    }
}
